<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HotelCategory;
use DataTables;
use Validator;

class HotelCategoryController extends Controller
{
    public function __construct()
    {
        $this->hotelCategoryStatus = ["1" => "Active", "2" => "Inactive"];
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $results = HotelCategory::isNotDeleted()->get();
            return DataTables::of($results)
                ->addIndexColumn()
                ->addColumn("hotel_category_name", function ($data) {
                    if (empty($data->hotel_category_name)) {
                        return "N/A";
                    }
                    return $data->hotel_category_name;
                })
                ->addColumn("hotel_category_code", function ($data) {
                    if (empty($data->hotel_category_code)) {
                        return "N/A";
                    }
                    return $data->hotel_category_code;
                })
                ->addColumn("hotel_category_desc", function ($data) {
                    if (empty($data->hotel_category_desc)) {
                        return "N/A";
                    }
                    return $data->hotel_category_desc;
                })
                ->addColumn("status", function ($data) {
                    return ($data->status == 1)?'Active' : 'Inactive';
                })
                ->addColumn("action", function ($data) {
                    $btn =
                        '<div class="btn-group">
                        <button type="button" class="btn btn-info">Action</button>
                        <button type="button" class="btn btn-info dropdown-toggle dropdown-icon" data-toggle="dropdown">
                          <span class="sr-only">Toggle Dropdown</span>
                        </button>
                        <div class="dropdown-menu" role="menu">
                          <a class="dropdown-item" href="javascript:;" onclick="ajaxEdit(' . $data->id . ');">Edit</a>
                          <a class="dropdown-item deletehotelcategory" href="javascript:;" data-hotel-category="' . $data->id . '">Delete</a>
                        </div>
                      </div>';
                    return $btn;
                })
                ->rawColumns(["action"])
                ->make(true);
        }
        $data["title"] = "Manage Hotel Category";
        return view("pages.admin.hotel-category.list", $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $hotelCategory = HotelCategory::find($request->id);
        $hotelCategory->is_deleted = 1;
        $hotelCategory->deleted_at = date('Y-m-d H:i:s');
        $hotelCategory->save();
        //$hotelCategory->delete();
        return response()->json(['status' => 'success', 'message' => 'Hotel Category information deleted successfully', 'error' => ''], 200);
    }

    public function ajaxAdd(Request $request)
    {
        $data["status"] = $this->hotelCategoryStatus;
        return view('pages.admin.hotel-category.ajaxAdd',$data);
    }
    public function addHotelCategory(Request $request)
    {
        $messages = array(
                        'hotel_category_name.required' => 'Hotel Category Name is Required',
                        'hotel_category_name_ar.required' => 'Hotel Category Name(AR) is Required',
                    );
        $validator = Validator::make($request->all(), ['hotel_category_name' => 'required','hotel_category_name_ar' => 'required'], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $ImageName = HotelCategory::create([  
                "hotel_category_name" => trim($request->hotel_category_name),
                "hotel_category_name_ar" => trim($request->hotel_category_name_ar),
                "hotel_category_code" => trim($request->hotel_category_code),
                "hotel_category_desc" => trim($request->hotel_category_desc),
                "hotel_category_desc_ar" => trim($request->hotel_category_desc_ar),
                "status" => trim($request->status),
            ]);
            return response()->json(['status' => 'success', 'message' => 'Hotel Category added successfully.', 'error' => ''], 200);
        }
    }
    public function ajaxEdit(Request $request)
    {
        $hotelCategoryInfo = HotelCategory::find($request->hotel_category_id);
        $data["hotelCategoryInfo"] = $hotelCategoryInfo;
        $data["status"] = $this->hotelCategoryStatus;
        return view('pages.admin.hotel-category.ajaxEdit',$data);
    }
    public function editHotelCategory(Request $request)
    {
        $messages = array(
            'hotel_category_name.required' => 'Hotel Category Name is Required',
            'hotel_category_name_ar.required' => 'Hotel Category Name(AR) is Required',
        );
        $validator = Validator::make($request->all(), ['hotel_category_name' => 'required','hotel_category_name_ar' => 'required'], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $hotelCategory = HotelCategory::find($request->hotel_category_id);
            $hotelCategory->hotel_category_name = $request->hotel_category_name;
            $hotelCategory->hotel_category_name_ar = $request->hotel_category_name_ar;
            $hotelCategory->hotel_category_code = $request->hotel_category_code;
            $hotelCategory->hotel_category_desc = $request->hotel_category_desc;
            $hotelCategory->hotel_category_desc_ar = $request->hotel_category_desc_ar;
            $hotelCategory->status = $request->status;
            $hotelCategory->save();

            return response()->json(['status' => 'success', 'message' => 'Hotel Category updated successfully.', 'error' => ''], 200);
        }
    }
}
