<?php

namespace App\Http\Controllers\Merchant;

use App\Http\Controllers\Controller;
use App\Http\Requests\Customer\StoreCustomerRequest;
use App\Http\Requests\Customer\UpdateCustomerRequest;
use Illuminate\Http\Request;
use App\Models\Customer;
use DataTables;
use Illuminate\Database\QueryException;
use Session;

class CustomerController extends Controller
{
    public function __construct()
    {
        $this->customerStatus = ["1" => "Active", "2" => "Inactive"];        
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if(\Auth::user()->can('list customer'))
        {
            if ($request->ajax()) {
            
                // $results = Customer::where('creater_id',\Auth::guard('merchant')->user()->id)
                //                 ->where('created_by',2)//Merchant
                //                 ->get();
                $results = Customer::where('creater_id',\Auth::user()->id)
                                ->where('created_by',\Auth::user()->id)//Merchant
                                ->get();

                return DataTables::of($results)
                ->addIndexColumn()
                ->addColumn("user_name", function ($data) {
                    if (empty($data->user_name)) {
                        return "N/A";
                    }
                    return $data->user_name;
                })
               
                ->addColumn("email", function ($data) {
                    if (empty($data->email)) {
                        return "N/A";
                    }
                    return $data->email;
                })
                ->addColumn("phone", function ($data) {
                    if (empty($data->phone)) {
                        return "N/A";
                    }
                    return $data->phone;
                })
                ->addColumn("action", function ($data) {
                    $btn = '<a class="btn btn-primary btn-xs" href="' . route('merchant.customer.show', $data->id) . '" data-toggle="tooltip" data-placement="top" title="View Customer"><i class="fa fa fa-eye"></i></a>&nbsp;';
                    $btn .=
                        '<a class="btn btn-info btn-xs" href="' .
                        route("merchant.customer.edit", $data->id) .
                        '" data-toggle="tooltip" data-placement="top" title="Edit Customer"><i class="fa fa-edit"></i> Edit</a>&nbsp;';
                    $btn .=
                        '<a class="btn btn-danger btn-xs deletecustomer" href="javascript:;" data-customer="' .
                        $data->id .
                        '" data-toggle="tooltip" data-placement="top" title="Delete Customer"><i class="fa fa-trash"></i> Delete</a>';
                    return $btn;
                })
                ->rawColumns(["action"])
                ->make(true);
            }

            $data["title"] = "Manage Customer";

            return view("pages.merchant.customer.list", $data);  
        }
        else
        {
            return redirect()->back()->with('error', __('Permission denied.'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if(\Auth::user()->can('create customer'))
        {
            $data["status"] = $this->customerStatus;
            return view('pages.merchant.customer.create', $data);
        }    
        else
        {
            return redirect()->back()->with('error', __('Permission denied.'));
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreCustomerRequest $request)
    {
        if(\Auth::user()->can('create customer'))
        {
            $is_exist = Customer::where('phone', $request->phone)->exists();
        
            if($is_exist) {
                $customer = Customer::where('phone', $request->phone)->first();
                $str_merchant_ids = trim($customer->merchant_ids).'~'.\Auth::user()->id;  
                // $str_merchant_ids = trim($customer->merchant_ids).'~'.\Auth::guard('merchant')->user()->id;  
                $arr_merchant_ids = array_unique(explode('~',$str_merchant_ids));
                $new_merchant_ids = implode('~',$arr_merchant_ids);
                try
                {
                    $updateCustomer = Customer::where('phone', $request->phone)
                    ->update([
                        'user_name' => $request->user_name,
                        'email' => $request->email,
                        'address_line_1' => $request->address_line_1,
                        'address_line_2' => $request->address_line_2,
                        'city' => $request->city,
                        'postal_code' => $request->postal_code,
                        'state' => $request->state,
                        'country' => $request->country,
                        'company_name' => $request->company_name,
                        'merchant_ids' => $new_merchant_ids,
                        'status' => $request->status     
                    ]);
                }
                catch(QueryException $ex)
                {
                    return redirect()
                    ->route("merchant.customer.index")
                    ->with("failed", $ex->getMessage());                 
                }        
            }else{
                try
                {
                    $customer = Customer::create([            
                        "user_name" => trim($request->user_name),
                        "email" => trim($request->email),
                        "address_line_1" => trim($request->address_line_1),
                        "address_line_2" => trim($request->address_line_2),
                        "city" => trim($request->city),
                        "postal_code" => trim($request->postal_code),
                        "state" => trim($request->state),
                        "country" => trim($request->country),
                        "phone" => trim($request->phone),
                        "company_name" => trim($request->company_name),            
                        "status" => trim($request->status),
                        "created_by" => \Auth::user()->id,
                       
                        "creater_id" => \Auth::user()->id,
                        "merchant_ids" => \Auth::user()->id,
                    ]);
                }
                catch(QueryException $ex)
                {
                    return redirect()
                    ->route("merchant.customer.index")
                    ->with("failed", $ex->getMessage());                 
                }
                    
            }
            
            return redirect()
            ->route("merchant.customer.index")
            ->with("success", "Customer created successfully!");
        }    
        else
        {
            return redirect()->back()->with('error', __('Permission denied.'));
        }  
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        if(\Auth::user()->can('view customer'))
        {
            $customerInfo = Customer::where('id', $id)->first();
            if (!$customerInfo)
            {
                return redirect()->route('merchant.customer.index');
            }
            $data['customer_id'] = $id;
            $data['customerInfo'] = $customerInfo;
            $data["status"] = $this->customerStatus;
            
            return view('pages.merchant.customer.show', $data);
        }
        else
        {
            return redirect()->back()->with('error', __('Permission denied.'));
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if(\Auth::user()->can('edit customer'))
        {
            $customerInfo = Customer::find($id);
            $data["customerInfo"] = $customerInfo;
            $data["status"] = $this->customerStatus;
            return view('pages.merchant.customer.edit',$data);
        }
        else
        {
            return redirect()->back()->with('error', __('Permission denied.'));
        }   
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateCustomerRequest $request, $id)
    {
        if(\Auth::user()->can('edit customer'))
        {
            try
            {
                $customer = Customer::find($id);
                $customer->user_name = $request->user_name;
                $customer->email = $request->email;
                $customer->address_line_1 = $request->address_line_1;
                $customer->address_line_2 = $request->address_line_2;
                $customer->city = $request->city;
                $customer->postal_code = $request->postal_code;
                $customer->state = $request->state;
                $customer->country = $request->country;
                $customer->phone = $request->phone;
                $customer->company_name = $request->company_name;
                $customer->status = $request->status;
                $customer->save();
            }
            catch(QueryException $ex) 
            {
                return redirect()
                ->route("merchant.customer.index")
                ->with("failed", $ex->getMessage());                 
            }
            return redirect()
                ->route("merchant.customer.index")
                ->with("success", "Customer updated successfully!");
        }
        else
        {
            return redirect()->back()->with('error', __('Permission denied.'));
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        if(\Auth::user()->can('delete customer'))
        {
            $customer = Customer::find($request->id);
            $customer->delete();
            Session::flash("success", "Customer information deleted successfully.");
            return 1;
        }
        else
        {
            return redirect()->back()->with('error', __('Permission denied.'));
        }
    }
}
