<?php

namespace App\Http\Requests\Supplier;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSupplierRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        //return $this->user()->can('edit supplier');
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "supplier_company" => "required",
            "supplier_code" => "required",
            "contractor_first_name" => "required",
            "contractor_last_name" => "required",
            "email" => "required|unique:users,email,".$this->user_id,           
            "phone" => "required|regex:/^[0-9]+$/|min:8|max:14|unique:users,phone,". $this->user_id . "",
            "status" => "required",
        ];
    }
}
