<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Notifications\Notifiable;

class Supplier extends Model
{
    use HasRoles, HasFactory,Notifiable;

    protected $primaryKey = 'supplier_id';

    protected $guarded = [];

    protected $guard_name = 'web';
    
    public static $merchantStatus = ["1" => "Active", "2" => "Inactive"];

    public function user()
    {
    	return $this->hasOne('App\Models\User','id','user_id');
    }
    public function scopeIsNotDeleted($query) 
    {
        return $query->where('is_deleted','!=',1);
    }
}
