<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('suppliers', function (Blueprint $table) {
            $table->bigIncrements('supplier_id');
            $table->bigInteger('user_id');
            $table->string('supplier_company')->nullable();
            $table->string('supplier_code')->nullable();
            $table->string('name_prefix')->nullable();
            $table->string('contractor_first_name')->nullable();
            $table->string('contractor_last_name')->nullable();
            $table->string('supplier_ref')->nullable();
            $table->string('license_number')->nullable();
            $table->text('address');
            $table->string('postal_code')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('country')->nullable();
            $table->string('email')->unique();
            $table->string('phone')->unique();
            $table->string('pan_number')->nullable();
            $table->string('tan_number')->nullable();
            $table->string('service_tax_number')->nullable();
            $table->string('iata_no')->nullable();
            $table->string('tta_no')->nullable();
            $table->string('fax_number')->nullable();
            $table->integer('hotel_confirmation')->default(0);
            $table->tinyInteger('is_deleted')->default(0);
            $table->dateTime('deleted_at')->nullable();
            $table->integer('status')->default(0);
            $table->integer('created_by')->default(0); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('suppliers');
    }
};
