<form class="form-horizontal" id="room_facility_edit_form" autocomplete="off" role="form" method="POST" action="#">
    @csrf
    {{method_field('PUT')}}
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('room_facility_name') has-error @enderror">
                <label for="room_facility_name" class="control-label"> {{ __('Room Facility Name') }} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="room_facility_name" id="room_facility_name" value="{{ $roomFacilityInfo->room_facility_name }}" placeholder="Room Facility Name" required>
                @if($errors->has('room_facility_name'))
                    <p class="text-danger">{{ $errors->first('room_facility_name') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('room_facility_name_ar') has-error @enderror">
                <label for="room_facility_name_ar" class="control-label"> {{ __('Room Facility Name(AR)') }} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="room_facility_name_ar" id="room_facility_name_ar" value="{{ $roomFacilityInfo->room_facility_name_ar }}" placeholder="Room Facility Name" required>
                @if($errors->has('room_facility_name_ar'))
                    <p class="text-danger">{{ $errors->first('room_facility_name_ar') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('room_facility_code') has-error @enderror">
                <label for="room_facility_code" class="col-control-label"> {{ __('Room Facility Code') }} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="room_facility_code" id="room_facility_code" value="{{ $roomFacilityInfo->room_facility_code }}" placeholder="Room Facility Code" required>
                @if($errors->has('room_facility_code'))
                    <p class="text-danger">{{ $errors->first('room_facility_code') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('room_section_type') has-error @enderror">
                <label for="room_section_type" class="col-control-label"> {{ __('Section Type') }}</label>
                {!! Form::select('room_section_type', $sectionType, $roomFacilityInfo->room_section_type, ['id' => 'room_section_type', 'class' => 'form-control m-bot15']) !!}
                @if($errors->has('room_section_type'))
                    <p class="text-danger">{{ $errors->first('room_section_type') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('room_facility_desc') has-error @enderror">
                <label for="room_facility_desc" class="control-label"> {{ __('Room Facility Desc') }}</label>
                <textarea class="form-control" name="room_facility_desc" id="room_facility_desc" rows="4">{{ $roomFacilityInfo->room_facility_desc }}</textarea>
                @if($errors->has('room_facility_desc'))
                    <p class="text-danger">{{ $errors->first('room_facility_desc') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('room_facility_desc_ar') has-error @enderror">
                <label for="room_facility_desc_ar" class="control-label"> {{ __('Room Facility Desc(AR)') }}</label>
                <textarea class="form-control" name="room_facility_desc_ar" id="room_facility_desc_ar" rows="4">{{ $roomFacilityInfo->room_facility_desc_ar }}</textarea>
                @if($errors->has('room_facility_desc_ar'))
                    <p class="text-danger">{{ $errors->first('room_facility_desc_ar') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('status') has-error @enderror">
                <label for="status" class="control-label"> {{ __('Status') }} <span class="text-danger">*</span></label>
                {!! Form::select('status', $status, $roomFacilityInfo->status, ['id' => 'status', 'class' => 'form-control m-bot15']) !!}
                @if($errors->has('status'))
                    <p class="text-danger">{{ $errors->first('status') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-sm-8 offset-sm-4">
        <input type="hidden" name="room_facility_id" id="room_facility_id" value="{{ $roomFacilityInfo->id }}" />
            <button type="button" id="editRoomFacilityBtn" class="btn btn-primary" onclick="return editRoomFacility();">{{ __('Update Room Facility') }}</button>
            <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
        </div>
    </div>
</form>
