<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ImageName;
use DataTables;
use Validator;

class ImageNameController extends Controller
{
    public function __construct()
    {
        $this->imageNameStatus = ["1" => "Active", "2" => "Inactive"];
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $results = ImageName::Get();
            return DataTables::of($results)
                ->addIndexColumn()
                ->addColumn("image_name", function ($data) {
                    if (empty($data->image_name)) {
                        return "N/A";
                    }
                    return $data->image_name;
                })
                ->addColumn("status", function ($data) {
                    return ($data->status == 1)?'Active' : 'Inactive';
                })
                ->addColumn("action", function ($data) {
                    $btn =
                        '<div class="btn-group">
                        <button type="button" class="btn btn-sm btn-info">Action</button>
                        <button type="button" class="btn btn-sm btn-info dropdown-toggle dropdown-icon" data-toggle="dropdown">
                          <span class="sr-only">Toggle Dropdown</span>
                        </button>
                        <div class="dropdown-menu" role="menu">
                          <a class="dropdown-item" href="javascript:;" onclick="ajaxEdit(' . $data->id . ');">Edit</a>
                          <a class="dropdown-item deleteimagename" href="javascript:;" data-image-name="' . $data->id . '">Delete</a>
                        </div>
                      </div>';
                    return $btn;
                })
                ->rawColumns(["action"])
                ->make(true);
        }
        $data["title"] = "Manage Image Name";
        return view("pages.admin.image-name.list", $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $ImageName = ImageName::find($request->id);
        $ImageName->delete();
        return response()->json(['status' => 'success', 'message' => 'Image Name information deleted successfully', 'error' => ''], 200);
    }

    public function ajaxAdd(Request $request)
    {
        $data["status"] = $this->imageNameStatus;
        return view('pages.admin.image-name.ajaxAdd',$data);
    }
    public function addImageName(Request $request)
    {
        $messages = ['image_name.required' => 'Image Name is Required'];

        $validator = Validator::make($request->all(), ['image_name' => 'required'], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $ImageName = ImageName::create([            
                "image_name" => trim($request->image_name),
                "status" => trim($request->status),
            ]);
            return response()->json(['status' => 'success', 'message' => 'Image Name added successfully.', 'error' => ''], 200);
        }
    }
    public function ajaxEdit(Request $request)
    {
        $imageNameInfo = ImageName::find($request->image_name_id);
        $data["imageNameInfo"] = $imageNameInfo;
        $data["status"] = $this->imageNameStatus;
        return view('pages.admin.image-name.ajaxEdit',$data);
    }
    public function editImageName(Request $request)
    {
        $messages = ['image_name.required' => 'Image Name is Required'];

        $validator = Validator::make($request->all(), ['image_name' => 'required'], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $ImageName = ImageName::find($request->image_name_id);
            $ImageName->image_name = $request->image_name;
            $ImageName->status = $request->status;
            $ImageName->save();

            return response()->json(['status' => 'success', 'message' => 'Image Name updated successfully.', 'error' => ''], 200);
        }
    }
}
